﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;
using System.Data;

namespace IndianHealthService.BMXNet.EHR.Model
{
    internal class CiaUser:CiaObject,User
    {

        public bool HasSecurityKey(String aString)
        {
            return "-1".Equals(this.RemoteSession.TransmitRPC("BMX SECURITY KEY", aString));
        }

        public List<string> RequestKeys()
        {
            try
            {
                List<String> keys = new List<string>();

                DataTable result = this.RemoteSession.TableFromCommand("BMXUserKeyRS^" + this.Ien);

                foreach (DataRow each in result.Rows)
                {
                    String key = each["KEY"].ToString().Trim();
                    if (key.Length > 0)
                    {
                        keys.Add(key.ToUpper());
                    }
                }
                return keys;

            }
            catch (Exception problem)
            {
                throw new BMXNetException("User key listing unavailable.", problem);
            }
        }


        public List<String> HasSecurityKeys(string[] keys)
        {
            List<String> missingKeys = new List<string>(keys);
            List<String> keychain = this.RequestKeys();
            foreach (string each in keychain)
            {
                if (missingKeys.Contains(each.ToUpper()))
                {
                    missingKeys.Remove(each.ToUpper());
                }
                if (missingKeys.Count == 0)
                {
                    break;
                }
            }
            return missingKeys;
        }


        public String Duz
        {
            get { return this.Ien; }
        }

        private String _name = null;

        public String Name
        {
            get { return _name; }
            set { _name = value; }
        }

        private Division _division = null;

        internal Division FriendDivision
        {
            set { _division = value; }
        }

    
        public Division Division
        {
            get
            {
                return _division;
            }
            set
            {
                throw new NotSupportedException("Division can not be set in EHR via BMX.");
            }
        }

    }
}
